/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.AlternateAppearance;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Group;
import javax.media.j3d.SceneGraphObject;

public class AlternateAppearanceState
extends LeafState {
    private int[] scopes;
    private int appearance;
    private int influencingBoundingLeaf;

    public AlternateAppearanceState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.scopes = new int[((AlternateAppearance)this.node).numScopes()];
            for (int i2 = 0; i2 < this.scopes.length; ++i2) {
                this.scopes[i2] = controller.getSymbolTable().addReference(((AlternateAppearance)this.node).getScope(i2));
            }
            this.appearance = controller.getSymbolTable().addReference(((AlternateAppearance)this.node).getAppearance());
            this.influencingBoundingLeaf = controller.getSymbolTable().addReference(((AlternateAppearance)this.node).getInfluencingBoundingLeaf());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.scopes.length);
        for (int i2 = 0; i2 < this.scopes.length; ++i2) {
            dataOutput.writeInt(this.scopes[i2]);
        }
        dataOutput.writeInt(this.appearance);
        dataOutput.writeInt(this.influencingBoundingLeaf);
        this.control.writeBounds(dataOutput, ((AlternateAppearance)this.node).getInfluencingBounds());
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.scopes = new int[dataInput.readInt()];
        for (int i2 = 0; i2 < this.scopes.length; ++i2) {
            this.scopes[i2] = dataInput.readInt();
        }
        this.appearance = dataInput.readInt();
        this.influencingBoundingLeaf = dataInput.readInt();
        ((AlternateAppearance)this.node).setInfluencingBounds(this.control.readBounds(dataInput));
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
    }

    public void buildGraph() {
        for (int i2 = 0; i2 < this.scopes.length; ++i2) {
            ((AlternateAppearance)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i2]));
        }
        ((AlternateAppearance)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        ((AlternateAppearance)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.influencingBoundingLeaf));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new AlternateAppearance();
    }
}

